<?php

  namespace App\Models;

  use Illuminate\Database\Eloquent\Model;

  class StaticContent extends Model
  {
      protected $table = 'static_content';
      protected $primaryKey = 'Content_id';
      public $timestamps = false;

      protected $fillable = [
          'Page_name',
          'Content',
          'Updated_by',
      ];

      public function updatedBy()
      {
          return $this->belongsTo(User::class, 'Updated_by', 'User_id');
      }
  }
