<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    protected $table = 'reviews';
    protected $primaryKey = 'Review_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Job_id',
        'Rating',
        'Comment',
    ];

    protected $casts = [
        'Rating' => 'integer',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function job()
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }
}
