<?php

  namespace App\Models;

  use Illuminate\Database\Eloquent\Model;

  class Refund extends Model
  {
      protected $table = 'refunds';
      protected $primaryKey = 'Refund_id';
      public $timestamps = true;

      protected $fillable = [
          'Payment_id',
          'Transaction_id',
          'Amount',
          'Currency',
          'Reason',
          'Status',
          'Gateway_response',
          'Processed_at',
      ];

      public function payment()
      {
          return $this->belongsTo(Payment::class, 'Payment_id', 'Payment_id');
      }

      public function transaction()
      {
          return $this->belongsTo(Transaction::class, 'Transaction_id', 'Transaction_id');
      }
  }
