<?php

  namespace App\Models;

  use Illuminate\Database\Eloquent\Model;

  class Recruiter extends Model
  {
      protected $table = 'recruiters';
      protected $primaryKey = 'Recruiter_id';
      public $timestamps = true;

      protected $fillable = [
          'Company_id',
          'User_id',
      ];

      protected $casts = [
          'Created_at' => 'datetime',
          'Updated_at' => 'datetime',
      ];

      public function company()
      {
          return $this->belongsTo(CompanyProfile::class, 'Company_id', 'Company_id');
      }

      public function user()
      {
          return $this->belongsTo(User::class, 'User_id', 'User_id');
      }
  }
