<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PracticeTest extends Model
{
    protected $table = 'practice_tests';
    protected $primaryKey = 'Test_id';
    protected $fillable = [
        'Lesson_id',
        'User_id',
        'Score',
        'Attempt_date',
        'Passed',
        'Total_questions',
        'Difficulty_level',
        'Duration_minutes',
    ];

    public $timestamps = false; // Disable timestamps if not needed

    protected $casts = [
        'Score' => 'float',
        'Attempt_date' => 'datetime',
        'Passed' => 'boolean',
        'Total_questions' => 'integer',
        'Difficulty_level' => 'string',
        'Duration_minutes' => 'integer',
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'Lesson_id', 'Lesson_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
?>
