<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Plan extends Model
{
    protected $table = 'plans';
    protected $primaryKey = 'Plan_id';
    public $timestamps = true;

    protected $fillable = [
        'Name',
        'Features',
        'Price',
        'Currency_id',
        'Duration',
        'Status',
        'Access_Level',
        'Max_Job_Postings',
        'Max_Interview_Schedules',
    ];

    protected $casts = [
        'Features' => 'array',
        'Price' => 'float',
        'Duration' => 'integer',
        'Status' => 'string',
        'Access_Level' => 'string',
        'Max_Job_Postings' => 'integer',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function currency(): BelongsTo
    {
        return $this->belongsTo(Currency::class, 'Currency_id', 'Currency_id');
    }
}
