<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $table = 'payments';
    protected $primaryKey = 'Payment_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Subscription_id',
        'Coupon_id', // Added Coupon_id
        'Amount',
        'Currency',
        'Payment_status',
        'Payment_gateway',
        'Transaction_id',
        'Course_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'Subscription_id', 'Subscription_id');
    }

    public function coupon()
    {
        return $this->belongsTo(Coupon::class, 'Coupon_id', 'Coupon_id'); // Added relationship
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'Payment_id', 'Payment_id');
    }

    
    public function refunds()
    {
        return $this->hasMany(Refund::class, 'Payment_id', 'Payment_id');
    }

    public function course()
{
    return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
}
}
