<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $table = 'notifications';
    protected $primaryKey = 'Notification_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Title',
        'Message',
        'Type',
        'Is_read',
    ];

    protected $casts = [
        'Type' => 'string',
        'Is_read' => 'boolean',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
