<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    use HasFactory;

    protected $table = 'messages';
    protected $primaryKey = 'Message_id';
    public $timestamps = true; // Disable timestamps

    protected $fillable = [
        'Sender_id', 'Receiver_id', 'Content', 'Is_read',
    ];

    public function sender()
    {
        return $this->belongsTo(User::class, 'Sender_id', 'User_id');
    }

    public function receiver()
    {
        return $this->belongsTo(User::class, 'Receiver_id', 'User_id');
    }
}
