<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Job extends Model
{
    protected $table = 'jobs';
    protected $primaryKey = 'Job_id';
    public $timestamps = true;

    protected $fillable = [
        'Company_id',
        'Title',
        'Description',
        'Location',
        'Salary',
        'Job_type',
        'Status',
        'deadline',
    ];

    protected $casts = [
        'Salary' => 'decimal:2',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Job_type' => 'string',
        'Status' => 'string',
        'deadline' => 'datetime', // Cast deadline as datetime
    ];

    /**
     * Serialize date fields to a custom format for JSON response.
     *
     * @param  DateTimeInterface  $date
     * @return string
     */
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function company()
    {
        return $this->belongsTo(CompanyProfile::class, 'Company_id', 'Company_id');
    }
}
