<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InterviewQuestion extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'interview_questions';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'Interview_question_id';

    /**
     * Indicates if the IDs are auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = true;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'Job_id',
        'Question_text',
        'Expected_answer',
        'Difficulty_level',
        'Time_limit',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'Difficulty_level' => 'string',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    /**
     * Get the job that this question belongs to.
     */
    public function job()
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }
}
