<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InterviewPreparation extends Model
{
    protected $table = 'interview_preparation';
    protected $primaryKey = 'Interview_preparation_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Tool_type',
        'Title',
        'Content_url',
        'Score',
        'Is_completed',
        'Feedback',
        'Job_id',
    ];

    protected $casts = [
        'Tool_type' => 'string',
        'Score' => 'decimal:2',
        'Is_completed' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function job(): BelongsTo
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }
}
