<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Interview extends Model
{
    protected $table = 'interviews';
    protected $primaryKey = 'Interview_id';
    public $timestamps = true;

    protected $fillable = [
        'Application_id',
        'Date',
        'Video_link',
        'Status',
        'Feedback',
        'Candidate_rating',
    ];

    protected $casts = [
        'Date' => 'datetime',
        'Status' => 'string',
        'Feedback' => 'string',
        'Candidate_rating' => 'float',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function application()
    {
        return $this->belongsTo(JobApplication::class, 'Application_id', 'Application_id');
    }

    /**
     * Override date serialization to use Y-m-d H:i:s format.
     */
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
?>
