<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    protected $table = 'groups';
    protected $primaryKey = 'Group_id';
    public $timestamps = true;

    protected $fillable = [
        'Name',
        'Description',
        'Created_by',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'Created_by', 'User_id');
    }

    public function members()
    {
        return $this->belongsToMany(User::class, 'user_groups', 'Group_id', 'User_id');
    }
}
