<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CourseCategory extends Model
{
    protected $table = 'course_categories';
    protected $primaryKey = 'Category_id';
    public $timestamps = true;

    protected $fillable = [
        'Name',
        'Description',
        'Parent_id',
        'Metadata',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Metadata' => 'array',
    ];

    public function parent(): BelongsTo
    {
        return $this->belongsTo(CourseCategory::class, 'Parent_id', 'Category_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(CourseCategory::class, 'Parent_id', 'Category_id');
    }
}
