<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Course extends Model
{
    protected $table = 'courses';
    protected $primaryKey = 'Course_id';
    public $timestamps = true;

    protected $fillable = [
        'Title',
        'Description',
        'Content_url',
        'Is_paid',
        'Price',
        'Language_id',
        'Category_id',
        'Status',
        'Pass_threshold',
        'Exam_Question',
    ];

    protected $casts = [
        'Is_paid' => 'boolean',
        'Price' => 'decimal:2',
        'Pass_threshold' => 'integer',
        'Exam_Question' => 'integer',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    /**
     * Get the language for the course.
     */
    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'Language_id', 'Language_id');
    }

    /**
     * Get the category for the course.
     */
    public function category(): BelongsTo
    {
        return $this->belongsTo(CourseCategory::class, 'Category_id', 'Category_id');
    }

    /**
     * Get the exam questions for the course.
     */
    public function examQuestions(): HasMany
    {
        return $this->hasMany(ExamQuestion::class, 'Course_id', 'Course_id');
    }

    /**
     * Get the sections for the course.
     */
    public function sections(): HasMany
    {
        return $this->hasMany(Section::class, 'Course_id', 'Course_id');
    }
}
