<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyProfile extends Model
{
    protected $table = 'company_profiles';
    protected $primaryKey = 'Company_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Company_name',
        'Description',
        'Logo_url',
        'Location',
        'Subscription_id',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'Subscription_id', 'Subscription_id');
    }
}
