<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CandidateSearch extends Model
{
    protected $table = 'candidate_search';
    protected $primaryKey = 'Profile_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'First_name',
        'Last_name',
        'Skills',
        'Certifications',
        'Location',
        'Experience',
    ];

    protected $casts = [
        'Skills' => 'array',
        'Certifications' => 'array',
        'Experience' => 'integer',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
