<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CandidateProfile extends Model
{
    protected $table = 'candidate_profiles';
    protected $primaryKey = 'Profile_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'First_name',
        'Last_name',
        'Resume_url',
        'Certifications',
        'Location',
        'Experience',
    ];

    protected $casts = [
        'Certifications' => 'array', // Assuming Certifications is stored as JSON
        'Experience' => 'integer', // Assuming Experience is in years
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
