<?php

namespace App\Listeners;

use App\Events\LessonCompletedEvent;
use App\Models\UserCourse;
use Illuminate\Support\Facades\Log;

class UpdateCourseProgressListener
{
   public function handle(LessonCompletedEvent $event)
{
    $videoProgress = $event->videoProgress;
    $userId = $videoProgress->User_id;
    $lessonId = $videoProgress->Lesson_id;

    Log::info("Event triggered for User {$userId}, Lesson {$lessonId}, Progress_id {$videoProgress->Progress_id}");

    $enrollment = UserCourse::where('User_id', $userId)
        ->whereHas('course.sections.lessons', function ($query) use ($lessonId) {
            $query->where('Lesson_id', $lessonId);
        })->first();

    if ($enrollment) {
        $totalLessons = $enrollment->course->sections->flatMap->lessons->count();
        $completedLessons = $enrollment->course->sections->flatMap->lessons
            ->map(function ($lesson) use ($userId) {
                $progress = $lesson->videoProgress->where('User_id', $userId)->first();
                return $progress && $progress->Is_completed ? 1 : 0;
            })->sum();

        $progressPercentage = $totalLessons > 0 ? ($completedLessons / $totalLessons) * 100 : 0;
        $status = $progressPercentage >= 100 ? 'completed' : ($progressPercentage > 0 ? 'in_progress' : 'enrolled');
        $completionStatus = $progressPercentage >= 100 ? 'completed' : ($progressPercentage > 0 ? 'in_progress' : 'enrolled');

        $enrollment->update([
            'Progress' => number_format($progressPercentage, 2),
            'Status' => $status,
            'Completion_status' => $completionStatus,
            'Last_activity' => now(),
            'Total_attempts' => $enrollment->Total_attempts + 1,
            'updated_at' => now(),
        ]);

        Log::info("Updated progress for User {$userId}, Course {$enrollment->Course_id}: {$progressPercentage}% after Lesson {$lessonId} completion");
    } else {
        Log::warning("No enrollment found for User {$userId} and Lesson {$lessonId}");
    }
}
}
