<?php

namespace App\Listeners;

use App\Events\JobApplied;
use App\Models\Notification;
use App\Models\JobApplication;
use Illuminate\Support\Facades\Log;

class SendJobAppliedNotification
{
    public function handle(JobApplied $event)
    {
        try {
            $application = $event->application;
            $job = $application->job;
            $company = $job->company ?? null;

            if ($company && $company->user) {
                $notification = Notification::create([
                    'User_id' => $company->user->User_id,
                    'Title' => 'New Job Application',
                    'Message' => 'A candidate has applied for the job "' . ($job->title ?? 'Untitled Job') . '" on ' . now()->toDateTimeString(),
                    'Type' => 'info',
                    'Is_read' => false,
                    'Created_at' => now(),
                    'Updated_at' => now(),
                ]);

                Log::info('Notification created for job application', [
                    'notification_id' => $notification->Notification_id,
                    'user_id' => $company->user->User_id,
                    'job_id' => $application->Job_id,
                ]);
            } else {
                Log::warning('No company or company user found for job application notification', [
                    'job_id' => $application->Job_id,
                ]);
            }
        } catch (\Exception $e) {
            Log::error('Error sending job application notification: ' . $e->getMessage(), [
                'job_application_id' => $event->application->Application_id,
            ]);
        }
    }
}
