<?php

namespace App\Http\Middleware;

use App\Models\CompanyFeatureUsage;
use App\Models\Subscription;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckPlanLimits
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        $subscription = Subscription::where('User_id', $user->User_id)->first();

        if ($subscription) {
            $companyId = $subscription->company->Company_id;
            $usages = CompanyFeatureUsage::where('Company_id', $companyId)->get();

            foreach ($usages as $usage) {
                if ($usage->Current_Usage >= $usage->Max_Usage) {
                    return response()->json([
                        'status' => 'error',
                        'message' => "You have reached the limit for {$usage->Feature_Name}. Please upgrade your plan.",
                        'redirect' => route('plan-payments.upgrade'), // Redirect to upgrade page
                    ], 403);
                }
            }
        }

        return $next($request);
    }
} 
