<?php

namespace App\Http\Controllers;

use App\Models\SubscriptionHistory;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class SubscriptionHistoryController extends Controller
{
    public function index($company_id): JsonResponse
    {
        // Validate company_id from URL parameter
        $validator = Validator::make(['company_id' => $company_id], [
            'company_id' => 'required|integer|exists:company_profiles,Company_id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $history = SubscriptionHistory::where('company_id', $company_id)
            ->with('plan')
            ->orderBy('start_date', 'desc')
            ->get();

        if ($history->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'message' => 'No subscription history found for the given company',
            ], 404);
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Subscription history retrieved successfully',
            'data' => $history,
        ], 200);
    }
}
