<?php

namespace App\Http\Controllers;

use App\Models\Section;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class SectionController extends Controller
{
    public function index(): JsonResponse
    {
        $sections = Section::with('course')->get();
        return response()->json([
            'status' => 'success',
            'data' => $sections,
        ], 200);
    }

    public function show($id): JsonResponse
    {
        $section = Section::with('course')->findOrFail($id);
        return response()->json([
            'status' => 'success',
            'data' => $section,
        ], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'Course_id' => 'required|exists:courses,Course_id',
            'Title' => 'required|string|max:255',
            'Description' => 'sometimes|string|nullable',
            'Order' => 'sometimes|integer',
            'Metadata' => 'sometimes|json',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $section = Section::create($request->only([
            'Course_id',
            'Title',
            'Description',
            'Order',
            'Metadata',
        ]));

        return response()->json([
            'status' => 'success',
            'data' => $section,
        ], 201);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $section = Section::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'Course_id' => 'sometimes|exists:courses,Course_id',
            'Title' => 'sometimes|string|max:255',
            'Description' => 'sometimes|string|nullable',
            'Order' => 'sometimes|integer',
            'Metadata' => 'sometimes|json',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $section->update($request->only([
            'Course_id',
            'Title',
            'Description',
            'Order',
            'Metadata',
        ]));

        return response()->json([
            'status' => 'success',
            'data' => $section,
        ], 200);
    }

    public function destroy($id): JsonResponse
    {
        $section = Section::findOrFail($id);
        $section->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Section deleted successfully',
        ], 200);
    }
}
