<?php

  namespace App\Http\Controllers;

  use App\Models\Recruiter;
  use Illuminate\Http\Request;
  use Illuminate\Http\JsonResponse;
  use Illuminate\Support\Facades\Validator;

  class RecruiterController extends Controller
  {
      public function index(): JsonResponse
      {
          $recruiters = Recruiter::with(['company', 'user'])->get();
          return response()->json([
              'status' => 'success',
              'data' => $recruiters,
          ], 200);
      }

      public function show($id): JsonResponse
      {
          $recruiter = Recruiter::with(['company', 'user'])->findOrFail($id);
          return response()->json([
              'status' => 'success',
              'data' => $recruiter,
          ], 200);
      }

      public function store(Request $request): JsonResponse
      {
          $validator = Validator::make($request->all(), [
              'Company_id' => 'required|exists:company_profiles,Company_id',
              'User_id' => 'required|exists:users,User_id',
          ]);

          if ($validator->fails()) {
              return response()->json([
                  'status' => 'error',
                  'errors' => $validator->errors(),
              ], 422);
          }

          $recruiter = Recruiter::create($request->only([
              'Company_id',
              'User_id',
          ]));

          return response()->json([
              'status' => 'success',
              'data' => $recruiter,
          ], 201);
      }

      public function update(Request $request, $id): JsonResponse
      {
          $recruiter = Recruiter::findOrFail($id);

          $validator = Validator::make($request->all(), [
              'Company_id' => 'sometimes|exists:company_profiles,Company_id',
              'User_id' => 'sometimes|exists:users,User_id',
          ]);

          if ($validator->fails()) {
              return response()->json([
                  'status' => 'error',
                  'errors' => $validator->errors(),
              ], 422);
          }

          $recruiter->update($request->only([
              'Company_id',
              'User_id',
          ]));

          return response()->json([
              'status' => 'success',
              'data' => $recruiter,
          ], 200);
      }

      public function destroy($id): JsonResponse
      {
          $recruiter = Recruiter::findOrFail($id);
          $recruiter->delete();

          return response()->json([
              'status' => 'success',
              'message' => 'Recruiter deleted successfully',
          ], 200);
      }
  }
