<?php

namespace App\Http\Controllers;

use App\Models\GroupMessage;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class GroupMessageController extends Controller
{
    public function index($groupId): JsonResponse
    {
        $messages = GroupMessage::where('Group_id', $groupId)->with('sender')->get();
        return response()->json([
            'status' => 'success',
            'data' => $messages,
        ], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'Group_id' => 'required|exists:Groups,Group_id',
            'Sender_id' => 'required|exists:Users,User_id',
            'Content' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $message = GroupMessage::create($request->only([
            'Group_id',
            'Sender_id',
            'Content',
        ]));

        broadcast(new \App\Events\NewGroupMessage($message));

        return response()->json([
            'status' => 'success',
            'data' => $message,
        ], 201);
    }
}
