<?php

namespace App\Http\Controllers;

use App\Models\AuditLog;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class AuditLogController extends Controller
{
    public function index(): JsonResponse
    {
        $logs = AuditLog::with('user')->get();
        return response()->json([
            'status' => 'success',
            'data' => $logs,
        ], 200);
    }

    public function show($id): JsonResponse
    {
        $log = AuditLog::with('user')->findOrFail($id);
        return response()->json([
            'status' => 'success',
            'data' => $log,
        ], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'User_id' => 'required|exists:users,User_id',
            'Action' => 'required|string|max:255',
            'Details' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $log = AuditLog::create([
            'User_id' => $request->User_id,
            'Action' => $request->Action,
            'Details' => $request->Details,
            'Created_at' => now(),
        ]);

        return response()->json([
            'status' => 'success',
            'data' => $log,
        ], 201);
    }
}
