<?php

namespace App\Events;

use App\Models\Job;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class JobPosted implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels;

    public $job;

    public function __construct(Job $job)
    {
        $this->job = $job;
    }

    public function broadcastOn()
    {
        return new Channel('jobs');
    }

    public function broadcastWith()
    {
        return ['job' => $this->job->only(['Job_id', 'Title', 'Description', 'Company_id'])];
    }
}
