<?php

namespace App\Events;

use App\Models\JobApplication;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class JobApplied implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels;

    public $application;

    public function __construct(JobApplication $application)
    {
        $this->application = $application;
    }

    public function broadcastOn()
    {
        return new Channel('job-applications');
    }

    public function broadcastWith()
    {
        $job = $this->application->job;
        $company = $job->company ?? null;
        $companyUserId = $company ? $company->user->User_id : null;

        return [
            'application' => $this->application->only(['Application_id', 'Job_id', 'User_id', 'Status']),
            'company_id' => $companyUserId,
        ];
    }
}
