<?php

namespace App\Console\Commands;

use App\Models\Lesson;
use App\Models\VideoProgress;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class FixDurationData extends Command
{
    protected $signature = 'course:fix-durations';
    protected $description = 'Fix incorrect duration values in lessons and video_progress tables';

    public function handle()
    {
        // Fix lessons.Duration (assumed in seconds if > 3600, convert to minutes)
        $lessonsUpdated = Lesson::where('Duration', '>', 3600)->update([
            'Duration' => DB::raw('ROUND(Duration / 60)')
        ]);
        Log::info("Updated {$lessonsUpdated} lessons with Duration converted from seconds to minutes");

        // Fix video_progress.Total_duration (assumed in seconds*60 if > 3600*60, convert to seconds)
        $progressUpdated = VideoProgress::where('Total_duration', '>', 3600 * 60)->update([
            'Total_duration' => DB::raw('ROUND(Total_duration / 60)')
        ]);
        Log::info("Updated {$progressUpdated} video_progress records with Total_duration converted");

        $this->info('Duration data fixed successfully.');
    }
}
