<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('private-chat.{id}', function ($user, $id) {
    // Use session for authentication in test mode
    if (auth()->check()) {
        return (int) auth()->id() === (int) $id;
    }
    return (int) session('user_id') === (int) $id; // Fallback to session
});
Broadcast::channel('group.{groupId}', function ($user, $groupId) {
    return $user->groups()->where('Groups.Group_id', $groupId)->exists();
});
